IF  EXISTS (SELECT * FROM sys.objects 	  
            WHERE object_id = OBJECT_ID(N'[dbo].[UFD_PROC_CONV_EXEMPLO]') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))

/****** Object:  UserDefinedFunction [dbo].[UFD_DESCRICAO_DESC]    Script Date: 14/08/2013 16:42:21 ******/
DROP FUNCTION [dbo].[UFD_PROC_CONV_EXEMPLO]
GO

CREATE FUNCTION UFD_PROC_CONV_EXEMPLO(@CD_EMP INT, @CD_FILIAL INT, @CD_PROD INT, @CD_CLI INT, @CD_CONV INT, @CD_PLANO_VENDA INT, @IS_RECEITA INT, @IS_LIBERA_VENDA INT, @QT_MAX INT, @VLR_DESC MONEY, @REMOVE_OFERTA INT )
RETURNS @RETURN_REC 
TABLE(
	CD_TBL_DESC 		INT,
	TP_DESC 			INT,
	FLAG_DESC_FIX 		INT,
	PERC_DESC			MONEY,
	PERC_DESC_MAX		MONEY,
	TP_NIVEL			INT,
	LIBERA_VD_CONV      INT,
	EXCLUE_OFERTA       INT,
	QT_MAX              INT
)
AS 
BEGIN

	-- SELECT * FROM UFD_PROC_CONV_EXEMPLO(1, 1, 1, 0)

	DECLARE @TIPO_DESCONTO INT = 21

	DECLARE @RS_TMP_DESC TABLE(
		CD_TBL_DESC 		INT,
		TP_DESC 			INT,
		FLAG_DESC_FIX 		INT,
		PERC_DESC			MONEY,
		PERC_DESC_MAX		MONEY,
		TP_NIVEL			INT,
		LIBERA_VD_CONV      INT,
		EXCLUE_OFERTA       INT,
		QT_MAX              INT
	)


	-------------------------------------------------------------------------------------------------------------------------------    
	--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO    
	-------------------------------------------------------------------------------------------------------------------------------    
	DECLARE @EST_PROD_ARV_MERC TABLE (  CD_EMP     INT,    
										CD_PROD     INT,    
										CD_ARV_MERC_CATEG  INT,    
										CD_ARV_MERC_LINHA  INT,    
										CD_MC     INT,    
										CD_ARV_MERC_FAMILIA  INT,            
										CD_FABRIC    INT)    


	-------------------------------------------------------------------------------------------------------------------------------    
	--BUSCANDO ARVORE MERC. DO PRODUTO    
	-------------------------------------------------------------------------------------------------------------------------------     
	INSERT INTO @EST_PROD_ARV_MERC    			
		SELECT     
			ARV.CD_EMP     ,    
			ARV.CD_PROD     ,    
			ARV.CD_ARV_MERC_CATEG  ,    
			ARV.CD_ARV_MERC_LINHA  ,    
			ARV.CD_MC     ,    
			ARV.CD_ARV_MERC_FAMILIA  ,            
			P.CD_FABRIC     
		FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV 
				INNER JOIN EST_PROD P ON    
					ARV.CD_EMP  = P.CD_EMP    
					AND ARV.CD_PROD = P.CD_PROD    
		WHERE   P.CD_EMP = @CD_EMP     
				AND P.CD_PROD = @CD_PROD 


	-------------------------------------------------------------------------------------------------------------------------------    
	--EXISTE ARVORE MERCADOLOGICA    
	-------------------------------------------------------------------------------------------------------------------------------     
	IF EXISTS(SELECT 1 FROM @EST_PROD_ARV_MERC)
	BEGIN

		IF @CD_CONV > 0
			INSERT INTO @RS_TMP_DESC
			SELECT 0, @TIPO_DESCONTO, 1, 15, 15, 999, @IS_LIBERA_VENDA, @REMOVE_OFERTA, @QT_MAX
		
	END

	INSERT INTO @RETURN_REC
	SELECT TOP 1 * 
		  FROM @RS_TMP_DESC 
		 ORDER BY TP_NIVEL ASC, PERC_DESC DESC

	RETURN
END